Chapter 5
#See brkdn.plot in plotrix instead of interaction.plot

#Guided example 1
xtp(gss,grass,polview3,wtss)
#xtp(gss,kids,polview3,wtss)
#Add obey2 to the select list. 
kids.no=  subset(gss, kids=="No")
kids.yes= subset(gss, kids=="Yes")
xtp(kids.no,grass, polview3,wtss)
xtp(kids.yes,grass, polview3,wtss)

#Guided example 2 [interaction]
xtp(kids.no,obey2, polview3,wtss)
xtp(kids.yes,obey2, polview3,wtss)

#Guided example 3: Mean comparisons [interaction]
nes.male=   subset(nes, gender=="Male")
nes.female= subset(nes, gender=="Female")
with(nes.male,  compmeans(dem.therm, income3.r,w=wt, plot=FALSE))
with(nes.female,compmeans(dem.therm, income3.r,w=wt, plot=FALSE))

#Guided example 4: Mean comparisons [additive]
nes.gays.yes=subset(nes, sexl.orient.famfrnds.f=="Yes")
nes.gays.no= subset(nes, sexl.orient.famfrnds.f=="No")
with(nes.gays.yes,compmeans(gay.therm,liberalism3,w=wt, plot=FALSE))
with(nes.gays.no, compmeans(gay.therm,liberalism3,w=wt, plot=FALSE))

#Guided example 5: Plotting numeric dependent variable
ddply(nes, .(sexl.orient.famfrnds.f,liberalism3), summarise,
  gay.mean = wtd.mean(gay.therm, wt))
#ddply is (z,x)
obj1=ddply(nes, .(sexl.orient.famfrnds.f,liberalism3), summarise,
  gay.mean = wtd.mean(gay.therm, wt))
print(obj1)
  #example shows how to shrink main title to fit with cex OR
  #use special character "\n" to break line
  #Note:default cex=1.2 for main title
interaction.plot(obj1$liberalism3, obj1$sexl.orient.famfrnds.f, obj1$gay.mean,
   xlab="Ideology",
   ylab="Mean rating",
   trace.label="Gay friends?",
   main=list("Ratings of Homosexuals, by Ideology \n and Whether R Has Gay Acquaintances",cex=1),
   xtick = T, 
   lwd=2,
   type="b",
   pch=21,
   cex.axis=.9,
   font.main=1)
#Notice how default legend is crowded into corner
#Intro legend function
interaction.plot(obj1$liberalism3, 
   obj1$sexl.orient.famfrnds.f, 
   obj1$gay.mean,
   xlab="Ideology",
   ylab="Mean rating",
   #trace.label="Gay friends?",
   main="Ratings of Homosexuals, by Ideology \n and Whether R Has Gay Acquaintances",
   xtick = T, 
   lwd=2,
   type="b",
   pch=21,
   cex.axis=.9,font.main=1,
   legend=F)
legend("topleft",legend=c("Yes","No"),lty=c(2,1),lwd=2, title="Does R Have \n Gay friends?",inset=0.1, bty="n")

#Guided example 6: Graphing indicator [interaction]
gss$obey.less.imp=as.numeric(gss$obey2=="Less important")
ddply(gss, .(kids,polview3), summarise,
  obey.mean = wtd.mean(obey.less.imp, wtss))
obj1=ddply(gss, .(kids,polview3), summarise,
  obey.mean = wtd.mean(obey.less.imp, wtss))
interaction.plot(obj1$polview3,
  obj1$kids,
  obj1$obey.mean*100,
   #trace.label="Kids?",
   ylab="Percent Obedience 'Less important'",
   xlab="Ideology",
   main="Attitudes toward Obedience in Children,\n by Ideology and whether R has Children",
   xtick = T,  
   lwd=2,
   type="b",
   pch=21,
   cex.axis=.8,
   font.main=1,
   legend=F) 
legend("topright",c("No","Yes"),lty=c(2,1),lwd=2,title="Does R have kids?",inset=0.1,bty="n")
 

#Exercise 1: world, democ.regime, frac.eth3, gdp.cap2
xtp(world,democ.regime,frac.eth3)
world.low.gdp= subset(world, gdp.cap2=="Low")
world.high.gdp=subset(world, gdp.cap2=="High")
xtp(world.low.gdp,  democ.regime,frac.eth3)
xtp(world.high.gdp, democ.regime,frac.eth3)
world$democ.yes=as.numeric(world$democ.regime=="Yes")
obj1=ddply(world, .(gdp.cap2,frac.eth3), summarise,
  democ.mean = wtd.mean(democ.yes))
print(obj1)
interaction.plot(obj1$frac.eth3, obj1$gdp.cap2, obj1$democ.mean*100,
   ylab="Percent",
   xlab="Fractionalization",main="Percentage of Democracies, by Ethnic Fractionalization \n and GDP Per Capita",
   xtick = T, lwd=2,type="b",pch=21,
   cex.axis=.8,font.main=1,
   legend=F)
legend("topright",c("High","Low"),lty=c(1,2),lwd=2,title="GDP",inset=0.1,bty="n")

#Exercise 2, world: women09, pr.sys, womyear2
womyear.early=subset(world, womyear2=="1944 or before")
womyear.late =subset(world, womyear2=="After 1944")
compmeans(womyear.early$women09,womyear.early$pr.sys,plot=F)
compmeans(womyear.late$women09,womyear.late$pr.sys,plot=F)
obj1=ddply(world, .(womyear2,pr.sys), summarise,
  pct.women = wtd.mean(women09))
print(obj1)
interaction.plot(obj1$pr.sys, obj1$womyear2, obj1$pct.women,
   ylab="Percent",
   xlab="PR System?",main="Percentage of Women in Parliament, by PR System \n and Timing of Suffrage",
   xtick = T, lwd=2,type="b",pch=21,
   cex.axis=.8,font.main=1, legend=F)
legend("topleft",c("1944 or Before", "After 1944"),
   lty=c(2,1), lwd=2,
   title="Timing of Women's Suffrage",inset=0.1,bty="n")

#Not run 
#Exercise ?, states, educ2, south, womleg.2010
#states$educ2=as.numeric(states$hs.or.more>57.05)
#states$educ2=as.ordered(states$educ2)
#levels(states$educ2)=c("Low","High")
#freq(states$educ2)
#states.south=   subset(states,south=="South")
#states.nonsouth=subset(states,south=="Nonsouth")
#with(states.south, compmeans(womleg.2010,educ2,plot=F))
#with(states.nonsouth, compmeans(womleg.2010,educ2,plot=F))
#interaction.plot(states$educ2,states$south,states$womleg.2010,
#   ylab="Percent",
 #  xlab="Education",main="Percentage of Women in State Legislatures,\n by State Education and Region",
  # xtick = T, lwd=2,type="b",pch=21,
   #cex.axis=.8,font.main=1,legend=F)
#legend("bottomright",c("Nonsouth","South"),lwd=2,lty=c(2,1),title="Region",inset=0.1,bty="n")

#Exercise 3, nes: environ.therm, enviro.jobs3f, enviro.jobs.imp2,wt
levels(nes$enviro.jobs.imp2)
enviro.not.very=subset(nes,enviro.jobs.imp2=="Not very")
enviro.very=    subset(nes,enviro.jobs.imp2=="Very/extrmly")
with(enviro.not.very,compmeans(environ.therm,enviro.jobs3f,w=wt,plot=F))
with(enviro.very,compmeans(environ.therm,enviro.jobs3f,w=wt,plot=F))

obj1=ddply(nes,.(enviro.jobs.imp2,enviro.jobs3f),summarise,
 enviro.mean=wtd.mean(environ.therm,wt))
print(obj1)
interaction.plot(obj1$enviro.jobs3f,obj1$enviro.jobs.imp2, obj1$enviro.mean, 
   ylab="Rating of Environmentalists",
   xlab="Environment vs Jobs",main="Ratings of Environmentalists, \n by Environmental Opinion and Issue Salience", 
   xtick = T, lwd=2,type="b",pch=21,
   cex.axis=.8,font.main=1, legend=F)
legend("topright",c("Low","High"),lty=c(2,1),title="Issue salience",inset=0.1,bty="n")

#Exercise 4, gss: race2, intrace.2, closeblk.3, closewht.3, wtss
levels(gss$race2)
white=subset(gss,race2=="White")
black=subset(gss,race2=="Black")
xtp(white,closewht.3,intrace.2,wtss,ylab="whites close to whites",xlab="Interviewer race")
xtp(white,closeblk.3,intrace.2,wtss,ylab="whites close to blacks",xlab="Interviewer race")
xtp(black,closewht.3,intrace.2,wtss,ylab="blacks close to whites",xlab="Interviewer race")
xtp(black,closeblk.3,intrace.2,wtss,ylab="blacks close to blacks",xlab="Interviewer race")
